#!%perl%

#########################################################
#            AVSMaker Professional Edition              #
#     Written entirely by Dan Jones (sf@termina.com)    #
#########################################################
#                                                       #
#                                                       #
# This script was created by:                           #
#                                                       #
# PerlCoders Web Specialties PTY.                       #
# http://www.perlcoders.com                             #
#                                                       #
# This script and all included modules, lists or        #
# images, documentation are copyright only to           #
# PerlCoders PTY (http://perlcoders.com) unless         #
# otherwise stated in the module.                       #
#                                                       #
# Purchasers are granted rights to use this script      #
# on any site they own. There is no individual site     #
# license needed per site.                              #
#                                                       #
# Any copying, distribution, modification with          #
# intent to distribute as new code will result          #
# in immediate loss of your rights to use this          #
# program as well as possible legal action.             #
#                                                       #
# This and many other fine scripts are available at     #
# the above website or by emailing the authors at       #
# staff@perlcoders.com or info@perlcoders.com           #
#                                                       #
#########################################################

#########################################################
#                                                       #
#  Small utility to ensure required permissions are     #
#  set on all files, run from within avspro/ directory  #
#                                                       #
#  Usage:                                               #
#       ./setperms.pl [-n]                              #
#                                                       #
#########################################################


my %perms;
$perms{exe}	= 0777;
$perms{norm}	= 0666;
$perms{suid}	= 0777;

use strict;
my @exes = qw(pl cgi sh);
my @suids = qw();

setperms(".");		# set permissions
chmod $perms{suid}, @suids;

sub	setperms {
	# recursive permission altering subroutine
	my $dir = shift;
	opendir(D, "$dir") or die $!;
	my @files = grep (!/^\.*$/, readdir(D));
	foreach my $item (@files) {
		if (-d "$dir/$item") {
			setperms("$dir/$item");
		} else {
			(my $ext = $item) =~ s/^.+\.([^.]+)$/$1/;
			if (grep(/^$ext$/, @exes)) {
				chmod $perms{exe}, "$dir/$item"
					or err("Could not modify permissions on file $dir/$item, check ownership is correct");
			} else {
				chmod $perms{norm}, "$dir/$item"
					or err("Could not modify permissions on file $dir/$item, check ownership is correct");
			}
		}
	}
	chmod $perms{exe}, $dir
		or err("Could not modify permissions on directory $dir, check ownership is correct");
}

sub	err {
	print "ERROR: $_[0]\n";
	exit;
}
